#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Mon Mar 19 00:29:08 2018

@author: mischaknabenhans
"""

#%% LOAD MODULES
from MyPythonRoutines.MyMath.Calculus import ODE
from time import sleep

import KeplerClass as KC
import pandas as pd
import Tkinter as tk
import tkFont
import threading as th
#import thread

#%% Global variables

CANVAS_WIDTH = 500
CANVAS1_HEIGHT = 500
CANVAS2_HEIGHT = 200

#%% LOAD DATA

SolSystData=pd.read_csv("SolSystData.dat", names=["Name", "Mass", "x", "y", "z", "vx", "vy", "vz"])

SolarSystemList = []
for indx,body in SolSystData.iterrows():
    SolarSystemList.append(KC.KeplerBody(body["Name"],float(body["Mass"]),
                                     float(body["x"]),float(body["y"]), float(body["z"]),
                                     float(body["vx"]),float(body["vy"]),float(body["vz"])))
    
"""
ALTERNATIVE WAY TO READ IN MIXED-TYPE DATA W/O PANDAS
import csv

names = []
mass = []
x_list = []
y_list = []
z_list = []
vx_list = []
vy_list = []
vz_list = []

with open("SolSystData.dat", 'r') as infile:
    csv_reader = csv.reader(infile, delimiter=',')
    for line in csv_reader:
        names.append(line[0])
        mass.append(line[1])
        x_list.append(line[2])
        y_list.append(line[3])
        z_list.append(line[4])
        vx_list.append(line[5])
        vy_list.append(line[6])
        vz_list.append(line[7])
infile.close()

SolarSystem = []
for i in range(9):
    SolarSystem.append(KC.KeplerBody(names[i], float(mass[i]), 
                                     float(x_list[i]), float(y_list[i]), float(z_list[i]), 
                                     float(vx_list[i]), float(vy_list[i]), float(vz_list[i])))
"""

#%% 

comas = [[], [], [], [], [], [], [], [], []]

class SolarSystem(th.Thread):
        
    def __init__(self, app):
        th.Thread.__init__(self)
        self.app = app
    
    def run(self):        
        t_ini = 0       # Starting on day 0
        t_fin = 60225   # Stop after one Neptunian orbital period of 165 years (= 60225 days)
        
        nSteps = 12045   #60225  # resolution: 1 time step per Earth day
        
        h = (t_fin-t_ini)/float(nSteps)
        
        #print(SolarSystem[3].getDistVec(SolarSystem[0], Norm=True))
        t = t_ini
        while t <= t_fin:
            #1st half of drift
            for body in SolarSystemList:
                r=body.getPos()
                v=body.getVel()
                
                [x,y,z]=ODE.LF_drift(r,v,h)
                body.setPos(x,y,z)
            
            #kick
            for body in SolarSystemList:
                v=body.getVel()
                a=body.getAcceleration([b for b in SolarSystemList if b is not body])
                
                [vx,vy,vz]=ODE.LF_kick(v,a,h)
                body.setVel(vx,vy,vz)
            
            #2nd half of drift
            for body in SolarSystemList:
                r=body.getPos()
                v=body.getVel()
                
                [x,y,z]=ODE.LF_drift(r,v,h)
                body.setPos(x,y,z)

            for i in range(len(SolSystData)):
                comas[i] = comas[i][-50:]
                comas[i].append(SolarSystemList[i].getPos())
                
            if int(t) % 50 == 0:
                self.plotxy(self.app.canvas1, 'Inner Planets XY-Plane', SolarSystemList[:5], comas[:5], CANVAS_WIDTH, CANVAS1_HEIGHT, 120)
                self.plotxy(self.app.canvas2, 'Outer Planets XY-Plane', [SolarSystemList[0]]+SolarSystemList[5:], comas[0:1] + comas[5:], CANVAS_WIDTH, CANVAS1_HEIGHT, 7)
                self.plotxz(self.app.canvas3, 'XZ-Plane', SolarSystemList[:5], comas[:5], CANVAS_WIDTH, CANVAS2_HEIGHT, 120, 1200)
                self.plotxz(self.app.canvas4, 'XZ-Plane', [SolarSystemList[0]]+SolarSystemList[5:], comas[0:1] + comas[5:],CANVAS_WIDTH, CANVAS2_HEIGHT, 7, 70)
                sleep(0.01)

            t = t+h
            
            #print(SolarSystem[3].getDistVec(SolarSystem[0], Norm=True))
    
    def plotxy(self, canvas, title, bodies, comas, width, height, scale):
        canvas.delete(tk.ALL)
        titleFont = tkFont.Font(family='Arial', size=16, weight='bold')
        canvas.create_text(10, 15, text=title, fill='white', anchor=tk.W, font=titleFont)
        for c in comas:
            for i in range(len(c)-1):
                x1 = width/2 + c[i][0] * scale
                y1 = height/2 - c[i][1] * scale
                x2 = width/2 + c[i+1][0] * scale
                y2 = height/2 - c[i+1][1] * scale
                color = '#808080'
                #canvas.create_oval(x, y, x+2, y+2, fill=color, outline=color)
                canvas.create_line(x1, y1, x2, y2, fill=color, width=2)
            
        for b in bodies:
            #(mass, r, v, name) = b
            
            x = width/2 + b.getPos()[0] * scale
            y = height/2 - b.getPos()[1] * scale
            if b.getMass() == 1.0:
                color = '#ffff80' # color for sun
                d = 7
            else:
                color='#ff8000' # color for planets
                d = 3
            canvas.create_oval(x, y, x+d, y+d, fill=color, outline=color)
            canvas.create_text(x, y-8, text=b.getName(), fill='white')
            
    def plotxz(self, canvas, title, bodies, comas, width, height, scalex, scalez):
        canvas.delete(tk.ALL)
        titleFont = tkFont.Font(family='Arial', size=16, weight='bold')
        canvas.create_text(10, 15, text=title, fill='white', anchor=tk.W, font=titleFont)
        for b in bodies:
            #(mass, r, v, name) = b
            x = width/2 + b.getPos()[0] * scalex
            y = height/2 - b.getPos()[2] * scalez
            if b.getMass() == 1.0:
                color = '#ffff80' # color for sun
                d = 7
            else:
                color='#ff8000' # color for planets
                d = 3
            canvas.create_oval(x, y, x+d, y+d, fill=color, outline=color)
            canvas.create_text(x, y-8, text=b.getName(), fill='white')
        
class Application(tk.Frame):
    def __init__(self, master=None):
        tk.Frame.__init__(self, master)
        self.grid()
        self.createWidgets()

    def createWidgets(self):
        self.canvas1 = tk.Canvas(self, bg="#000000", width=CANVAS_WIDTH, height=CANVAS1_HEIGHT)
        self.canvas1.grid(row=0, column=0)
        self.canvas2 = tk.Canvas(self, bg="#000000", width=CANVAS_WIDTH, height=CANVAS1_HEIGHT)
        self.canvas2.grid(row=0, column=1)
        self.canvas3 = tk.Canvas(self, bg="#000000", width=CANVAS_WIDTH, height=CANVAS2_HEIGHT)
        self.canvas3.grid(row=1, column=0)
        self.canvas4 = tk.Canvas(self, bg="#000000", width=CANVAS_WIDTH, height=CANVAS2_HEIGHT)
        self.canvas4.grid(row=1, column=1)

#------------------------------------------------------------------------------
# Main
#------------------------------------------------------------------------------

app = Application()
app.master.title('Solar System')
task = SolarSystem(app)
task.start()
app.mainloop()


