#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Computation and plot of the Lorenz attractor

Created on Mon Apr  9 08:11:33 2018

@author: mischaknabenhans
"""
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import axes3d
from MyMath.Calculus.ODE import RK4

def LorenzSystem(t,y):
    # Parameter
    a = 10
    b = 28
    c = 8./3.
    
    X = y[0]
    Y = y[1]
    Z = y[2]
    
    return np.array([a*(Y-X),X*(b-Z)-Y,X*Y-c*Z])

X_i = 0
Y_i = 1
Z_i = 1.5

y = np.array([X_i,Y_i,Z_i])
nSteps = 10000
t = 0
t_final = 100

[ylist, tlist] = RK4(LorenzSystem, y, nSteps, t, t_final)



Fig,ax = plt.subplots(subplot_kw={'projection': '3d'})
ax.plot(ylist[:,0],ylist[:,1],ylist[:,2], lw = 0.65, label = 'Lorenz attractor')
ax.set_xlabel("X")
ax.set_ylabel("Y")
ax.set_zlabel("Z")
ax.legend()
plt.show()
