#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Feb 24 16:56:18 2018

@author: mischaknabenhans
"""

#%% Import modules
from MyMath.Calculus import ODE
import matplotlib.pyplot as plt
import numpy as np

#%% Define auxiliary functions

def LoktaVolterra(t,y):
    eps = np.array([2,-1.06])
    gamma = np.array([0.02,-0.01])
    
    yrev=y[::-1]
    
    return y * (eps - gamma * yrev)
    
#%% Main function
     
# Define IC
preyGrid = np.linspace(10,100,10)
predatorGrid = np.linspace(10,50,9)

YList = []
for (i,j) in zip(preyGrid,predatorGrid):
    YList.append(np.array([i,j]))

# Solve ODE
ResList = []
for i in range(len(YList)):
    [ylist,tlist] = ODE.RK4(LoktaVolterra,YList[i],1000, 0, 10)

    yarray=np.asarray(ylist)
    tarray=np.asarray(tlist)
    
    ResList.append([tarray,yarray])

# Plot

lbls=["prey", "predator"]

Fig,axs = plt.subplots(1,2)
ax=axs[0]
for i in range(ResList[0][1].shape[1]):
    ax.plot(ResList[0][0],ResList[0][1][:,i],label=lbls[i])

ax.set_xlabel("time t")
ax.set_ylabel("population N")
ax.legend(loc="best")

ax=axs[1]
for j in range(len(YList)):
    ax.plot(ResList[j][1][:,0],ResList[j][1][:,1],label=lbls[i])
    
ax.set_xlabel("prey population")
ax.set_ylabel("predator population")

tit = plt.tight_layout()
Fig.show()
