#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Feb 24 16:56:18 2018

@author: mischaknabenhans
"""

#%% Import modules
import matplotlib.pyplot as plt

#%% Define auxiliary functions

def RK4_f(t, N1, N2, eps1, gamma1):
    return N1 * (eps1 - gamma1*N2)
    
def RK4_g(t, N1, N2, eps2, gamma2):
    return -N2 * (eps2 - gamma2*N1)

def SolveLoktaVolterra(eps1,eps2,gamma1,gamma2,N1,N2,t,t_final):
    
    nSteps = 1000
        
    stepwidth = (t_final-t)/float(nSteps)
    
    N1list = [N1]
    N2list = [N2]
    tlist = [t]
    
    for i in range(nSteps):
        t += stepwidth
        
        k0 = stepwidth * RK4_f(t, N1, N2,eps1, gamma1)
        l0 = stepwidth * RK4_g(t, N1, N2,eps2, gamma2)
        
        k1 = stepwidth * RK4_f(t+stepwidth/2., N1+k0/2., N2+l0/2.,eps1, gamma1)
        l1 = stepwidth * RK4_g(t+stepwidth/2., N1+k0/2., N2+l0/2.,eps2, gamma2)
    
        k2 = stepwidth * RK4_f(t+stepwidth/2., N1+k1/2., N2+l1/2.,eps1, gamma1)
        l2 = stepwidth * RK4_g(t+stepwidth/2., N1+k1/2., N2+l1/2.,eps2, gamma2)
        
        k3 = stepwidth * RK4_f(t+stepwidth, N1+k2, N2+l2,eps1, gamma1)
        l3 = stepwidth * RK4_g(t+stepwidth, N1+k2, N2+l2,eps2, gamma2)
        
        N1 = N1 + (k0 + 2*k1 + 2*k2 + k3)/6.0
        N2 = N2 + (l0 + 2*l1 + 2*l2 + l3)/6.0
        
        N1list.append(N1)
        N2list.append(N2)
        tlist.append(t)
        
    return [N1list,N2list,tlist]
    
#%% Main function
eps1 = 2
eps2 = 1.06
    
gamma1 = 0.02 
gamma2 = 0.01
    
N1_start = 100
N2_start = 15
    
[N1list1,N2list1,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 25
    
[N1list2,N2list2,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 35
    
[N1list3,N2list3,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 50
    
[N1list4,N2list4,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 70
    
[N1list5,N2list5,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 80
    
[N1list6,N2list6,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)

N1_start = 100
N2_start = 100
    
[N1list7,N2list7,tlist] = SolveLoktaVolterra(eps1,eps2,gamma1,gamma2, \
                                           N1_start, N2_start, t=0, t_final=20)
    
Fig,axs = plt.subplots(1,2)
ax=axs[0]
ax.plot(tlist,N1list1,label="prey")
ax.plot(tlist,N2list1,label="predator")
ax.set_xlabel("time t")
ax.set_ylabel("population N")
ax.legend(loc="best")

ax=axs[1]
ax.plot(N1list1,N2list1)
ax.plot(N1list2,N2list2)
ax.plot(N1list3,N2list3)
ax.plot(N1list4,N2list4)
ax.plot(N1list5,N2list5)
ax.plot(N1list6,N2list6)
ax.plot(N1list7,N2list7)
ax.set_xlabel("prey population")
ax.set_ylabel("predator population")

tit = plt.tight_layout()
Fig.show()
