#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Mon Mar 12 11:43:24 2018

@author: mischaknabenhans
"""
#%% Import modules
import numpy as np
import matplotlib.pyplot as plt

#%% Global variables describing the system
a = 1.
eList = np.linspace(0.1,0.9,9)
mu = 1

#%% Auxiliary functions

def hFunc(mu,a,e):
    return mu*a*(1+e)

def leapFrog(r,v,Dt,e):
    
    h=hFunc(mu,a,e)
    
    r_half = r + 0.5*Dt*v
    v_new = v + Dt*(-mu/(r_half**2)+h**2/(r_half**3))
    r_new = r_half + 0.5*Dt*v_new
    
    return [r_new, v_new]

def SolveHamiltonEvolution(r,v,Dt,e,nSteps):
    rList = [r]
    vList = [v]
    #EList = [RadialHamiltonian(r,v)]

    # Compute phase space evolution
    counter=0
    while counter < nSteps:
        [r, v] = leapFrog(r,v,Dt,e)
        rList.append(r)
        vList.append(v)
        
        counter += 1
        
    rvec = np.array(rList)
    vvec = np.array(vList)
    
    return [rvec, vvec]


#%% Main

t_ini = 0
t_fin = 1000
nSteps = int(1e4)

Dt = float(t_fin-t_ini)/nSteps
tvec = np.linspace(t_ini, t_fin, nSteps+1)

# Compute phase space evolution

rResArr = []
vResArr = []

for e in eList:
    rIC = a*(1+e)
    vIC = 0
    [rRes, vRes] = SolveHamiltonEvolution(rIC,vIC,Dt,e,nSteps)
    rResArr.append(rRes)
    vResArr.append(vRes)

Labels=map(str,eList)
Fig, ax = plt.subplots()
for i in range(len(eList)):
    ax.plot(rResArr[i],vResArr[i],label="e="+Labels[i])
ax.legend(loc="best",ncol=2)
ax.set_xlabel("q")
ax.set_ylabel("p")
Fig.show()