""" Test Debug Profile -- Exercise: Writing a test suite

Author: Nicola Chiapolini, nicola _dot_ chiapolini _at_ mnf _dot_ uzh _dot_ ch

"""
import string

def clean(input_, allow=string.ascii_letters, replace=""):
    """Remove all but the allowed characters from the input string.

    Input arguments:
        input_ -- input string
        allow -- iterable with allowed characters (default: A-z)
        replace -- single character string
            the character is used instead of illegal ones (default: remove illegal characters)

    Output:
        string containing only allwed characters (and replace character if given)

    Raises:
        ValueError if replace-value is not a single character string
    """
    if type(replace) != str or len(replace) > 1:
        raise ValueError("replace must be a single character or an empty string")
    output = ""
    for c in input_:
        if c in allow:
            output += c
        else:
            output += replace
    return output
