# distutils: language = c++
# distutils: sources = tools/analyzer.cpp

from libcpp.vector cimport vector

cdef extern from "tools/analyzer.h":
    cdef cppclass DataProcessor:
        DataProcessor(int n_iterations) except +
        void loadData(vector[double] data)
        void run()
        vector[double] extractData()

cdef class PyDataProcessor:
    cdef DataProcessor *thisptr

    def __cinit__(self,int n_iterations):
        self.thisptr = new DataProcessor(n_iterations)

    def __dealloc__(self):
        del self.thisptr

    def loadData(self, vector[double] data):
        self.thisptr.loadData(data)
        return

    def run(self):
        self.thisptr.run()
        return
        
    def extractData(self):
        return self.thisptr.extractData()