import subprocess
import glob

for file_ in glob.glob("*/*.output"):
    print(f"regenerating {file_}")
    path, fname = file_.split("/")
    res = subprocess.run(["python3", fname[:-6]+"py"], capture_output=True, cwd=path)
    with open(file_, "w") as output:
        if res.stdout:
            output.write(res.stdout.decode())
            if res.stderr:
                raise RuntimeError(f"{file_}: stdout present and stderr not empty")
        else:
            output.write(res.stderr.decode())

