# distutils: sources = Vector.cpp UnitVector.cpp
# distutils: language = c++

from cython.operator cimport dereference as deref, preincrement as inc
from libcpp.vector cimport vector

cdef extern from "Vector.h":
    cppclass Vector:
        double x,y,z
        Vector() except +
        Vector(double, double, double) except +
        double length()
        vector[double] coordinates()
        Vector operator+(Vector)
        Vector operator-()
        double operator*(Vector)
        Vector operator^(Vector)

cdef extern from "UnitVector.h":
    cppclass UnitVector(Vector):
        UnitVector() except +
        UnitVector(Vector) except +
        UnitVector(double, double, double) except +
        
cdef class PyVector:
    cdef Vector* thisptr
    def __cinit__(self,double x=0.0,double y=0.0, double z=0.0):
        self.thisptr = new Vector(x,y,z)
    def __dealloc__(self):
        del self.thisptr
#    def length(self):
#        return self.thisptr.length()
#    def coordinates(self):
#        return self.thisptr.coordinates()
#    def __add__(PyVector lhs, PyVector rhs):
#        res = PyVector()
#        res.thisptr[0] = lhs.thisptr[0]+rhs.thisptr[0]
#        return res
#    def __neg__(self):
#        res = PyVector()
#        res.thisptr[0] = - self.thisptr[0]
#       return res
#    def __mul__(PyVector lhs, PyVector rhs):
#        return lhs.thisptr[0]*rhs.thisptr[0]
#    def __mod__(PyVector lhs, PyVector rhs):
#        res = PyVector()
#        res.thisptr[0] = lhs.thisptr[0]^rhs.thisptr[0]
#        return res
        
cdef class PyUnitVector:
    cdef UnitVector* thisptr
    def __cinit__(self,double x,double y, double z):
        self.thisptr = new UnitVector(x,y,z)
    def __dealloc__(self):
        del self.thisptr
#    def length(self):
#        return self.thisptr.length()
#    def coordinates(self):
#        return self.thisptr.coordinates()
#    def __add__(PyVector lhs, PyVector rhs):
#        res = PyVector()
#        res.thisptr[0] = lhs.thisptr[0]+rhs.thisptr[0]
#        return res
#    def __neg__(self):
#        res = PyVector()
#        res.thisptr[0] = - self.thisptr[0]
#        return res
#    def __mul__(PyVector lhs, PyVector rhs):
#        return lhs.thisptr[0]*rhs.thisptr[0]
#    def __mod__(PyVector lhs, PyVector rhs):
#        res = PyVector()
#        res.thisptr[0] = lhs.thisptr[0]^rhs.thisptr[0]
#        return res

        
def tryIt():
    cdef UnitVector* uv = new UnitVector(1,2,3)
    cdef Vector* v1     = new Vector(3,4,5)
    cdef Vector* v2     = new UnitVector(1,3,4)
    cdef Vector* v3     = new Vector();
    try:
        print("length is: ",v1.length())
        print("coordinates are: ",v1.x,v1.y,v1.z)
        v3[0] = v1[0] ^ v2[0]
        print("length is: ",v3.length())
        print("coordinates are: ",v3.coordinates())  
    finally:
        del uv,v1,v2,v3
