import logging
logger = logging.getLogger(__name__)

logfile = logging.FileHandler("mylib.log", "w")
logfile.setFormatter(logging.Formatter(
    "%(asctime)s -- %(levelname)s: %(message)s"
    ))
logger.addHandler(logfile)

def main():
    print("**logging on all levels**")
    logger.debug("This is debug output.")
    logger.info("This is an info.")
    logger.warning("This is a  warning.")
    logger.error("There was an error.")
    logger.critical("A critical situation occured.")

if __name__ == "__main__":
    logger.setLevel(logging.CRITICAL)
    main()
