import logging

log = logging.getLogger(__name__)
# set lowest log-level, handlers can only
# increase threshold/reduce verbosity
log.setLevel(logging.DEBUG)

# add an output-channel for stderr
log.addHandler(logging.StreamHandler())
# reduce ouput for last handler
log.handlers[-1].setLevel(logging.ERROR)

# create and configure output to a file
# (use "a" instead of "w" to append)
logfile = logging.FileHandler("demo.log", "w")
# define format ouf Log-lines
# - see `pydoc3 logging.Formatter` for variables
# - extra variables (e.g. `%(var)s`) must be passed
#   via keyword argument `extra`
logfile.setFormatter(logging.Formatter(
    "%(asctime)s -- %(levelname)s, %(var)s: %(message)s"
    ))
log.addHandler(logfile)

log.error("This is bad", extra={"var": 42})
log.info("Info: %s", "busy", extra={"var": 0})
