import unittest
import numpy as np
from random import choice
from prime import find_factors


class PrimeTester(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        cls.primes = [2,3,5,7,11,13]

    def test_primes(self):
        #given
        for p in self.primes:
            with self.subTest(config = p):
                result = find_factors(p)
                #then
                self.assertEqual(result, [p])


    def test_fuzzy(self):
        """ show numerical fuzzying """
        for __ in range(10):
            #given
            expect = [choice(self.primes) for _ in range(5)]
            expect.sort()
            input_ = np.prod(expect)
            #when
            with self.subTest(config = expect):
                result = find_factors(input_)
                #then
                self.assertEqual(result, expect)

    def test_70(self):
        """ test general case """
        #given
        input_ = 70
        expect = [2,5,7]
        #when
        result = find_factors(input_)
        #then
        self.assertEqual(result, expect)

if __name__ == "__main__":
    unittest.main(verbosity=2)
