# You're working on an address book application and are asked to modify the existing .proto file to include the option to store the address of a given person in addition to the other information already described in the .proto file.
# First, extend the .proto file to include the new field (with a reasonable type).
# We can add the following line in the .proto file:
# optional string address = 5;
# Then, use the protocol buffer compiler to compile the updated .proto file.
# We compile again using the following command in the terminal:
# protoc --python_out=./ addressbook.proto
# After that, read the data from the file person, update it by adding a value for the address, and save it to a different file.
# Finally, read the new file back using Python to cross-check that it contains the address you specified.

import addressbook_pb2

if __name__ == "__main__":
    # Read the information from the file.
    person = addressbook_pb2.Person()
    with open("person", "rb") as f:
        person.ParseFromString(f.read())
    print("Original data structure:")
    print(person)

    # Update the information of the person to also include an address and save this information to a file.
    person.address = "Winterthurerstrasse 190, 8057 Zurich"
    print("New data structure:")
    print(person)
    with open("person_with_address", "wb") as f:
        f.write(person.SerializeToString())

    # Read back the information from the file to cross-check that the person has an address.
    person_with_address = addressbook_pb2.Person()
    with open("person_with_address", "rb") as f:
        person_with_address.ParseFromString(f.read())

    print("Cross-check of new data structure:")
    print(person_with_address)
