import analyzer_cython

if __name__ == "__main__":
    # Example usage of the analyzer_cython module
    data = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]  # data
    N_steps = 100_000 # number of steps for processing

    dataprocessor = analyzer_cython.PyDataProcessor(N_steps) 
    # Since we are using Cython, we had to create a wrapper class that has a different name from the C++ class
    dataprocessor.loadData(data) # Read the data into the processor
    dataprocessor.run() # Run the data processing
    result = dataprocessor.extractData() # Extract the processed data
    for entry in result:
        print(entry)
    del dataprocessor  # Clean up the object
    