%module vect_swig

%include "std_vector.i"
%include "exception.i"

%include "Vector.h"
%include "UnitVector.h"

%{
#include "Vector.h"
#include "UnitVector.h"
%}

%template(dVector) std::vector<double>;

%exceptionclass std::range_error;

%exception {
    try {
        $action
    } catch (std::range_error & e) {
        SWIG_exception(SWIG_IndexError, e.what());
    }
}
