How to test your python installation
====================================

1. git
------
To test git, open your terminal (or the 'git bash' installed by 'git for windows') and
execute

`git`

if you get an error message, something is wrong. If you get a message starting `usage: git ...`
git is working.


2. Python modules
-----------------
Run in your shell or cmd

`$ python modules_test.py`

If the script runs without an import error, it shows that your python installation has all the required modules.
It will print at the end 'All imports successful!'

Make sure you are using Python 3, i.e. the 'python' command points to Python 3. 
If not sure open the python terminal

`$ python`

and see which version of python it is referring to

If there are import errors, (re)install with pip (or the package manager of your distribution) the missing modules


3. Cython (optional)
--------------------
To test your cython installation run in your shell or cmd

`$ python setup_cython_test.py build_ext --inplace`

Again make sure it is Python 3.

If there is no error then run

`$ python cython_run.py`

It should print 'Hello, Cython!'

If you have run into issues, in particular regarding the installation of a C/C++ compiler please check:
https://cython.readthedocs.io/en/latest/src/quickstart/install.html


4. SWIG (optional)
------------------
To test your SWIG installation run in your shell or cmd

`$ swig -c++ -python swig_test.i`

afterwards

`$ python setup_swig_test.py build_ext --inplace`

and

`$ python swig_run.py`

If all commands run without an error and the last one prints 'Hello, SWIG!', then the installation should be OK.

