from dataclasses import dataclass
import datetime

@dataclass
class Article:
    title: str
    authors: list[str]
    date: datetime.date
    url: str

dna = Article(
    """Molecular Structure of Nucleic Acids:
A Structure for Deoxyribose Nucleic Acid""",
    ["Watson, J. D.", "Crick, F. H. C."],
    datetime.date(1953, 4, 25),
    "https://doi.org/10.1038/171737a0",
)
print(dna.title)
