#!/usr/bin/env python3
""" Process some integers. """
import click

@click.command()
@click.argument("integers", type=int, nargs=-1, required=True)
@click.option("--sum/--max", "-s/-m", "sum_", default=False, help="use sum or max (default: max)")
def process(sum_, integers):
    accumulator = max
    if sum_:
        accumulator = sum
    print(accumulator(integers))

if __name__ == "__main__":
    # pylint: disable=no-value-for-parameter
    process()
