# Advanced Scientific Programming in Python
# Exercise 3 (unit testing and coverage)
# Author: Pietro Berkes <berkes _at_ brandeis _dot_ edu>
#         Nicola Chiapolini <nchiapol _at_ physik _dot_ uzh _dot_ ch>


import unittest

class TestCenter(unittest.TestCase):
    def test_center_default(self):
        # cases are (arguments, [possible results of centering])
        cases = [(('a', 5),    ['  a  ']),
                 (('a', 4),    [' a  ', '  a ']),
                 (('[]', 5),   [' []  ', '  [] ']),
                 (('[]', 4),   [' [] ']),
                 (('test', 2), ['test']),
                 (('', 3),     ['   ']),
                 ((' a', 5),   ['  a  ', '   a '])]

        # test all cases
        for (str_, width), expected in cases:
            with self.subTest(config = (str_, width)):
                output = str_.center(width)

                self.assertEqual(len(output), max(width, len(str_)))
                self.assertIn(output, expected)

    def test_center_fillchar(self):
        cases = [(('a', 5), ['**a**']),
                 (('a', 4), ['*a**', '**a*'])]

        # test all cases
        for fillchar in ['#', '5', ' ']:
            for (str_, width), expected in cases:
                with self.subTest(config = (str_, width, fillchar)):
                    output = str_.center(width, fillchar)

                    self.assertEqual(len(output), max(width, len(str_)))
                    self.assertIn(output.replace(fillchar, '*'), expected)

    def test_errors(self):
        with self.assertRaises(TypeError):
            'a'.center(3, '')

        with self.assertRaises(TypeError):
            'a'.center(5, '*#')

if __name__ == '__main__':
    unittest.main()
