import unittest
from random import choice
from numpy import prod
from prime import find_factors

class PrimeTester(unittest.TestCase):
    
    @classmethod
    def setUpClass(cls):
        cls.primes = [2,3,5,7,11,13,17,19]

    def test_primes(self):
        for value in self.primes:
            with self.subTest(config=value):
                # when
                result = find_factors(value)
                # then
                self.assertEqual(result, [value])


    def test_fuzzy(self):
        # given
        for _ in range(10):
            expect = [choice(self.primes) for _ in range(5)]
            expect.sort()
            value = prod(expect)
            with self.subTest(config = value):
                # when
                result = find_factors(value)
                # then
                self.assertEqual(result, expect)


    def test_70(self):
        # given
        value = 70
        expect = [2,5,7]
        # when
        result = find_factors(value)
        # then
        self.assertEqual(result, expect)

if __name__ == "__main__":
    unittest.main(verbosity=1)
