cdef extern from "fastinvsqrt/fis.c":
    double fast_inv_sqrt(double number)

def py_fis(number:double) -> double:
    """Function to calculate 1/x**0.5 and hence helpful for normalising vectors
    
    Parameters
    ----------
    number : double
        
    Returns
    -------
    double :
        Inverse of the square root
    """
    return fast_inv_sqrt(number)

def norm_vector(values:list) -> list:
    """Calculates the normalised vector with length 1
    
    Parameters
    ----------
    values : list
        Components of the vector
    
    Returns
    -------
    list :
        Components of the normalised vector
    """
    length_squared = sum([x**2 for x in values])
    return [x*fast_inv_sqrt(length_squared) for x in values]