class Vector3D:
    def __init__(self, x, y, z):
        self.x, self.y, self.z = x, y, z

    def __add__(self, other):
        return type(self)(self.x + other.x,
                          self.y + other.y,
                          self.z + other.z)

    @property
    def length(self):
        return (self.x**2+self.y**2
                +self.z**2)**0.5

    @length.setter
    def length(self, length):
        scale = length/self.length
        self.x *= scale; self.y *= scale; self.z *= scale

    # decorators could be replaced by `length = property(....)`
    # but functions would need distinguishable names
