class UncertVal:
    def __init__(self, value, uncertainty=0):
        self.val = value
        self.std = uncertainty

    def __str__(self):
        return f"{self.val} +/- {self.std}"

    def add(self, other, corr=0):
        variance = (self.std ** 2 + other.std ** 2
                    + 2 * self.std * other.std * corr)
        return type(self)(self.val + other.val,
                          variance ** 0.5)

    def __add__(self, other):
        return self.add(other)
