from urllib.request import urlopen

class Sensor:
    def __init__(self, offset=0, scale_factor=1):
        self.offset = offset
        self.scale = scale_factor

    def get_value(self):
        return (self._get_raw() + self.offset) * self.scale

    def _get_raw(self):
        raise NotImplementedError

class WebSensor(Sensor):
    def __init__(self, url, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._url = url

    def _get_raw(self):
        res = urlopen(self._url)
        return float(res.read())
