import numpy as np

class Dataset:
    mandatory_metadata = ["label", "color", "marker"]
    def __init__(self, datafile, **metadata):
        for key in self.mandatory_metadata:
            if key not in metadata:
                raise KeyError("Missing metadata", key)
        self.metadata = metadata
        self.data = np.loadtxt(datafile, delimiter=",")
        self.validate()

    def validate(self):
        if self.data.shape != (4, 10):
            raise ValueError("Bad shape of data, has to be (4, 10).")

    @property
    def label(self):
        return self.metadata["label"]

    def peak_row(self):
        return self.data.max(axis=1).argmax()
