class NonFlyingBehavior(FlyingBehavior):
    def take_off(self):
        print("It's not working :-(")
    def fly_to(self, destination):
        raise Exception("I'm not flying.")
    def land(self):
        print("That won't be necessary.")

class RubberDuck(Duck):
    def __init__(self):
        self.flying_behavior = NonFlyingBehavior()
    def quack(self):
        print("Squeak!")
    def display(self):
        print("Small yellow rubber duck.")

class DecoyDuck(Duck):
    def __init__(self):
        self.flying_behavior = NonFlyingBehavior()
    # different implementation for display/quack
