"""
Note: We use Dog.all_.add in init on purpose.
- Anything inheriting from Dog is still a dog and should be counted in all.
- It is too early to discuss type(self) here, we mention this in the Vector example.
"""
class Dog:
    breed = "dog"
    all_ = set()

    def __init__(self, name, color="brown"):
        self.name = name
        self.color = color
        Dog.all_.add(self)

    def __repr__(self):
        return f"{self.name}: {self.color} {self.breed}"

Dog("snowy", "white")
balto = Dog("balto")
balto.breed = "husky"
print(Dog.all_) # {snowy: white dog, balto: brown husky}
