# Scientific Programming in Python
# Best Practice Exercise
# Author: Nicola Chiapolini
"""Trainer for Mental Arithmetic.

This program helps you to train simple mental arithmatic

"""
# pylint: disable=no-else-return
from random import randint

seen_pairs = []


def _generate_pair(max_: int) -> tuple[int, int]:
    """Generate a random pair of integers.

    Arguments:
        max_ -- maximal allowed value for the sum of the two integers

    """
    sum_ = randint(0, max_)
    a = randint(0, sum_)
    b = randint(0, sum_ - a)
    return a, b


def addition(max_: int) -> int:
    """Do one round of addition.

    Prompts with a single addition problem and evaluate the result.

    Arguments:
        max_ -- maximal allowed value for the result

    Return value:
        'points' obtained (i.e. 1 if correct, 0 otherwise)

    """
    pair = _generate_pair(max_)
    while pair in seen_pairs:
        pair = _generate_pair(max_)
    seen_pairs.append(pair)
    a, b = pair

    while True:
        try:
            result = int(input(f"{a} + {b} = "))
        except ValueError:
            print("Bad Input!")
            continue
        break
    if a + b == result:
        print("✓")
        return 1
    else:
        print("✗")
        return 0


def train(rounds: int = 10, max_sum: int = 10) -> None:
    """Run a training session.

    Arguments:
        rounds -- number of rounds to train
        max_sum -- train with numbers up to this value

    """
    n_correct = 0
    for _ in range(rounds):
        n_correct += addition(max_sum)
    print(f"{n_correct} out of {rounds} correct answers.")
    if n_correct == rounds:
        print("Perfect!")
    elif n_correct / rounds >= 0.8:
        print("Well done!")


if __name__ == "__main__":
    train()
