class FlyingBehavior:
    def take_off(self):
        print("Run fast, flap wings.")
    def fly_to(self, destination):
        print("Fly to", destination)
    def land(self):
        print("Extend legs, touch down.")

class Duck:
    def __init__(self):
        self.flying_behavior = FlyingBehavior()
    def take_off(self):
        self.flying_behavior.take_off()
    def fly_to(self, destination):
        self.flying_behavior.fly_to(destination)
    def land(self):
        self.flying_behavior.land()
    # display, quack as before...
