class Dog:
    def __init__(self, color="brown"):
        self.color = color
        self._mood = 5

    @property
    def mood(self):
        if self._mood < 0:
            return "angry"
        return "happy"

    @mood.setter
    def mood(self, value):
        if not -10 <= value <= 10:
            raise ValueError("Bad range!")
        self._mood = value

# create an instance 'snowy' of the class Dog
snowy = Dog("white")
print("Snowy is", snowy.mood)
snowy.mood = 100
