from beverage_base import Coffee

class Milk:
    def __init__(self, beverage):
        self.base = beverage

    def __str__(self):
        return f"{self.base}, with milk"

    @property
    def cost(self):
        return self.base.cost + 0.30

coffee_with_milk = Milk(Coffee())

if __name__ == "__main__":
    assert str(coffee_with_milk) == "coffee, with milk"
    assert abs(coffee_with_milk.cost - 3.30) < 1e-8
    print(__file__, "ok")
