class Beverage:
    # imagine some attributes like
    # temperature, amount left,...
    _name = "beverage"
    _cost = 0.00

    def __str__(self):
        return self._name

    @property
    def cost(self):
        return self._cost

class Coffee(Beverage):
    _name = "coffee"
    _cost = 3.00

class Tea(Beverage):
    _name = "tea"
    ...

if __name__ == "__main__":
    c = Coffee()
    assert str(c) == "coffee"
    assert abs(c.cost - 3.00) < 1e-8
    print(__file__, "ok")
