Preparing Your System for the School
====================================

To prepare your system for the school, please install the software listed below.
Once done, you can test your installation using the scripts and instructions.
in the `installation_test`-folder

git
---
You will need git for the school. You can download the correct installer for your
operating system from https://git-scm.com/download/.

Python
------
Obviously, you will need Python installed. Make sure to install Python 3 (>= 3.7).
There are many ways to install Python on any operating system.
The official downloads are available from https://www.python.org/downloads/

A very common alternative is to use Anaconda (https://www.anaconda.com/). Anaconda is a toolkit
tailored for data science with a large repository of almost everything you might want to use
when doing data science.

Choose the setup you are most comfortable with.

Python Modules
--------------
Once you have Python installed, you will need to install additional modules.
The requirement file provided together with these instructions contains
  a list of the most important modules.
Make sure they are installed and you know how to install further modules
  should this be necessary.

To install the packages in the requirement file, it might be enough to run

```
$ pip install -r requirements.txt
```

on the command line, but this depends on your setup.

(These modules depend on many others. For example you do not see `numpy`
listed explicitly, but we will of course use it heavily.)

Special Tools
-------------
[Don't worry if you are lost in this section or get stuck when installing,
we will provide a fall-back option in case this does not work on your laptop]

Several lecutres use additional software outside the core Python ecosystem,
  e.g. to interact with databases or integrate other programming languages.
If you want to try these on your own laptop, you need to install the software
  listed below.
The mentioned Python modules are included in `requirements_tricky.txt`

  * Graphviz
The `pygraphviz` module allows to visualize graphs, but depends on
  https://www.graphviz.org/

  * SQL Database
Please install SQLite (Version 3) from
  https://www.sqlite.org/download.html

If you want to try a more extensive relational database,
additionally install PostgreSQL
  https://www.postgresql.org/download/
if you do, also install the `psycopg2` module.

  * C/C++
Please install the `cython` module in Python.
This in turn requires a C compiler.
See
  https://cython.readthedocs.io/en/latest/src/quickstart/install.html
  for details.
In addition you will need to be able to compile C++-files.
Usually this is available from the same sources as C.

  * swig
The easiest option is probably to install swig using the `swig` module.
If this does not work, download and install the correct version for your
local OS from
  http://www.swig.org/download.html
