import subprocess

# show `du -h *` and `du -h .` on the commandline
result = subprocess.run(["du", "-h", "."])
print(result)
print()

result = subprocess.run(["du", "-h", "."], capture_output=True)
print(result)
print("output: ", result.stdout.decode())
print("error:  ", result.stderr.decode())
print()

result = subprocess.run(["du", "-h", "*"], capture_output=True)
print("output: ", result.stdout.decode())
print("error:  ", result.stderr.decode())
print()

result = subprocess.run(["du -h *"], capture_output=True, shell=True)
print("output: ", result.stdout.decode())
print("error:  ", result.stderr.decode())
print()

result2 = subprocess.run(["cat"], capture_output=True, input=b"test")
print("output:  ", result2.stdout.decode())
