import unittest
import random
import numpy as np
from prime import find_factors

class PrimeTester(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        cls.primes = [2,3,5,7,11,13,17,19]

    def test_fuzzy(self):
        for _ in range(10):
            # given
            expect = [random.choice(self.primes) for _ in range(5)]
            expect.sort()
            value = np.prod(expect)
            with self.subTest(config = value):
                #when
                result = find_factors(value)
                #then
                self.assertEqual(result, expect)

    def test_70(self):
        #given
        input_ = 70
        expect = [2,5,7]
        #when
        result = find_factors(input_)
        #then
        self.assertEqual(result, expect)

    def test_primes(self):
        for prime in self.primes:
            with self.subTest(config = prime):
                #when
                result = find_factors(prime)
                #then
                self.assertEqual(result, [prime])


if __name__ == "__main__":
    unittest.main(verbosity=2)

