""" Test Debug Profile -- Exercise: Writing a test suite

Author: Nicola Chiapolini, nicola _dot_ chiapolini _at_ mnf _dot_ uzh _dot_ ch

"""
import unittest
from cleanup import cleanup

class TestCleanup(unittest.TestCase):
    string = "H3l1o W0r1d!"

    def test_general(self):
        """ a) general input """
        # given
        expect = "HloWrd"
        # when
        result = cleanup(self.string)
        # then
        self.assertEqual(result, expect)

    def test_allow(self):
        """ b) different allow-list """
        # given
        allow = [f"{c}" for c in range(10)]
        expect = "3101"
        # when
        result = cleanup(self.string, allow)
        # then
        self.assertEqual(result, expect)

    def test_defaultallow(self):
        """ c) default allow-list """
        # given
        expect = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        expect += expect.lower()
        # when
        result = cleanup(expect)
        # then
        self.assertEqual(result, expect)

    def test_replace(self):
        """ d) replace: single character string """
        # given
        expect = "H_l_o_W_r_d_"
        # when
        result = cleanup(self.string, replace="_")
        # then
        self.assertEqual(result, expect)

    def test_raises(self):
        """ e) replace: bad value """
        with self.assertRaises(ValueError):
            cleanup(self.string, replace="ab")

if __name__ == "__main__":
    unittest.main(verbosity=2)
