#ifndef RECTANGLE_H
#define RECTANGLE_H

#include <vector>

#include "Shape.h"

using namespace shapes;

namespace shapes {
    
    class Rectangle : public Shape {
    public:
        int x0, y0, x1, y1;
        Rectangle(int x0, int y0, int x1, int y1);
        ~Rectangle();
        Rectangle operator*(Rectangle& rhs){
            return Rectangle(x0,y0,rhs.x1,rhs.y1);
        };
        void printInfo();
        int getLength();
        int getHeight();
        int getArea();
        void move(int dx, int dy);
        void move(int d);
        std::vector<double> getCoordinates();
        std::vector<Rectangle*> getRectAsVector();
        void whine() throw(ShapeError);
    };
}

#endif
