import unittest
from prime import find_factors
from random import choice
from numpy import prod

class PrimeTester(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        cls.primes = [2,3,5,7,11,13,17,19]

    def test_primes(self):
        for p in self.primes:
            with self.subTest(config = p):
                result = find_factors(p)
                self.assertEqual(result, [p])

    def test_fuzzy(self):
        for _ in range(10):
            #given
            expect = [choice(self.primes) for _ in range(6)]
            expect.sort()
            value = prod(expect)
            with self.subTest(config = value):
                #when
                result = find_factors(value)
                #then
                self.assertEqual(result, expect)

    def test_70(self):
        #given
        input_ = 70
        expect = [2,5,7]
        #when
        result = find_factors(input_)
        #then
        self.assertEqual(result, expect)

if __name__ == "__main__":
    unittest.main(verbosity=2)
