# coding=utf-8

"""
Advanced Python School
OOP and Design Patterns

by: Zbyszek Szmek, Bartosz Telenczuk
"""


class ASCIIIterable:
    def __init__(self, str):
        self.str = str

    def __iter__(self):
        return ASCIIIterator(self.str)


class ASCIIIterator:
    def __init__(self, str):
        self.offset = -1
        self.str = str

    def __next__(self):
        self.offset += 1
        try:
            return ord(self.str[self.offset])
        except IndexError:
            raise StopIteration()


if __name__ == "__main__":

    ascii_iter = ASCIIIterable("Scientific Programming with Python 2021")

    for ch in ascii_iter:
        print(ch)
