"""
OOP vector-exercise

written by Christian Elsasser for Scientific Programming with Python.

Modified by Jonas Eschle

This module contains all elements for vector classes.
"""

import math


class Vector:
    """Base class for vectors"""

    def __init__(self, numbers):
        """Vector that stores an array of numbers.

        Args:
            numbers: array of numbers
        """
        self._numbers = numbers

    @property
    def dimension(self):
        """Get dimension of the vector"""
        return len(self._numbers)

    def __mul__(self, other):
        """Scalar multiplication

        Args:
            other: Vector with same dimension or scalar
        """
        pass  # To be implemented

    def __add__(self, other):
        """Vector addition

        Args:
            other: Vector with same dimension or scalar
        """
        pass  # To be implemented

    def __str__(self):
        pass  # To be implemented


class Vector3D(Vector):
    pass
