#include "Rectangle.h"
#include <iostream>

using namespace shapes;



Rectangle::Rectangle(int X0, int Y0, int X1, int Y1) : Shape()
{
    x0 = X0;
    y0 = Y0;
    x1 = X1;
    y1 = Y1;
    std::cout << "Here I am" << std::endl;
}

Rectangle::~Rectangle()
{
    std::cout << "Byebye" << std::endl;
}

void Rectangle::printInfo(){
    std::cout << "Rectangle" << std::endl;
}

int Rectangle::getLength()
{
    return (x1 - x0);
}

int Rectangle::getHeight()
{
    return (y1 - y0);
}

int Rectangle::getArea()
{
    return (x1 - x0) * (y1 - y0);
}

void Rectangle::move(int dx, int dy)
{
    x0 += dx;
    y0 += dy;
    x1 += dx;
    y1 += dy;
}

void Rectangle::move(int d){
    move(d,d);
}

std::vector<double> Rectangle::getCoordinates(){
    std::vector<double> v(4);
    v[0] = x0;
    v[1] = y0;
    v[2] = x1;
    v[3] = y1;
    return v;
}

std::vector<Rectangle*> Rectangle::getRectAsVector(){
    std::vector<Rectangle*> v(1);
    v[0] = this;
    return v;
}

void Rectangle::whine() throw(ShapeError) {
    throw ShapeError((char*)"I don't want to work!");
}
