import unittest
import os

class IOTest(unittest.TestCase):
    test_file = "test_file.md"

    def setUp(self):
        with open(self.test_file, "w") as file_:
            file_.writelines(["hello\n", "welt\n"])

    def tearDown(self):
        os.remove(self.test_file)

    def test_reading(self):
        with open(self.test_file) as file_:
            lines = file_.readlines()
        self.assertEqual(lines, ["hello\n", "welt\n"])

    def test_writing(self):
        with open(self.test_file, "w") as file_:
            file_.writelines(["hello\n", "universe\n"])
        with open(self.test_file) as file_:
            lines = file_.readlines()
        self.assertEqual(lines, ["hello\n", "universe\n"])

    def test_appending(self):
        with open(self.test_file, "a") as file_:
            file_.writelines(["hello\n", "universe\n"])
        with open(self.test_file) as file_:
            lines = file_.readlines()
        self.assertEqual(lines, ["hello\n", "welt\n", "hello\n", "universe\n"])

    def test_lines(self):
        with open(self.test_file) as file_:
            lines = file_.readlines()
       # self.assertEqual("hello\n", lines[0])
       # self.assertEqual("welt\n", lines[1])
        self.assertTrue("hello\n"==lines[0] or "welt\n" == lines[1])


if __name__ == "__main__":
    unittest.main(verbosity=2)

