# cython: experimental_cpp_class_def=True
# distutils: language=c++

# Anagram finder

from libcpp.map cimport map
from libcpp.vector cimport vector
from libcpp.string cimport string

from cython.operator cimport dereference as deref, preincrement as inc

def findAnagram():
    cdef string fileName = "/usr/share/dict/words"
    inputFile = open(fileName)
    cdef map[string,vector[string]] matchingMap
    cdef string key
    for word in inputFile:
        word = word[:-1]
        key = str.encode(''.join(sorted(list(word.lower()))))
        matchingMap[key].push_back(str.encode(word))
    cdef vector[string] maxEntry
    cdef signed long max
    max = 0
    cdef map[string,vector[string]].iterator it
    it = matchingMap.begin()
    cdef int i
    while it != matchingMap.end():
        mEnt = deref(it)
        if mEnt.second.size()>max:
            maxEntry = vector[string]()
            maxEntry.push_back(mEnt.first)
            max = mEnt.second.size()
        elif mEnt.second.size()==max:
            maxEntry.push_back(mEnt.first)
        inc(it)
    for i in range(maxEntry.size()):
        return str(maxEntry[i],'utf-8')