
def find_factors(value):
    """ find prime factors of value

    Example
    -------
    >>> find_factors(2)
    [2]
    >>> find_factors(15)
    [3, 5]
    """
    factors = []
    divisor = 2
    while value > 1:
        if value % divisor == 0:
            factors.append(divisor)
            value /= divisor
        else:
            divisor += 1
    return factors
