# cython: experimental_cpp_class_def=True

# Anagram finder

from libcpp.map cimport map
from libcpp.algorithm cimport sort,copy
from libcpp.iterator cimport back_inserter
from libcpp.vector cimport vector
from libcpp.string cimport string
from libcpp.pair cimport pair

from libc.stdio cimport *

from cython.operator cimport dereference as deref, preincrement as inc


def findAnagram():
    # Defining the source of the words
    cdef char* fileName = "/usr/share/dict/words"
    # pointer for input file
    cdef FILE* file_in
    inputFile = fopen(fileName,"rb")
    if inputFile==NULL:
        raise FileNotFoundError(
            2,
            "No such file or directory: {0:s}".format(fileName)
            )
    # Pointer for the line
    cdef char* line = NULL
    cdef size_t l = 0
    cdef ssize_t read
    # Create a key-vector pair to store all the terms matching the same set of characters
    cdef map[string,vector[string]] matchingMap
    # Variable to store term and key (i.e. sorted characters)
    cdef string key,word
    # Loop over lines
    while True:
        read = getline(&line,&l,inputFile)
        if read == -1:
            break
        line[read-1] = 0;
        word = string(line)
        key = string(word).lower()
        sort(key.begin(),key.end())
        matchingMap[key].push_back(word)
    fclose(inputFile)
    # Create map that captures all the terms with maximum number of terms
    cdef map[string,vector[string]] maxEntry
    cdef signed long max_count
    max_count = 0
    cdef map[string,vector[string]].iterator it
    it = matchingMap.begin()
    cdef pair[string,vector[string]] mEnt
    cdef int i
    while it != matchingMap.end():
        mEnt = deref(it)
        # If new term group has more entries, delete old one and start a new one
        if mEnt.second.size()>max_count:
            maxEntry = map[string,vector[string]]()
            maxEntry.insert(mEnt)
            max_count = mEnt.second.size()
        # If new term group has the same number of entries, just add it
        elif mEnt.second.size()==max_count:
            maxEntry.insert(mEnt)
        inc(it)
    print("Set generating the maximum number of words:")
    it = maxEntry.begin()
    # Loop over all the terms with maximum entries and print out the key
    while it != maxEntry.end():
        mEnt = deref(it)
        inc(it)
        print(mEnt.first.decode("utf-8"))
