#ifndef VECTOR_H
#define VECTOR_H

#include <vector>

class Vector {
    
public:
    double x;
    double y;
    double z;
    
    Vector();
    Vector(double,double,double);
    ~Vector(){};
    
    // euclidian lenght
    double length();
    
    // coordinates as a std::vector with three entries
    std::vector<double> coordinates();
    
    // adding two vectors
    Vector operator+(const Vector&);
    
    // inverse of the vector
    Vector operator-();
    
    // multiplying a vector with a scalar
    Vector operator*(double);
    
    // dot product of two vectors
    double operator*(const Vector&);
    
    // cross product of two vectors
    Vector operator^(const Vector&);

};

#endif