"""
Example solution for exercise of OOP.

written by Christian Elsasser for Scientific Programming with Python

This module contains all elements for vector classes.
"""

import math

class Vector:
    """Base class for vectors
    """

    def __init__(self,numbers):
        """Initialize the vector.
        numbers - array of numbers
        """
        self._numbers  = numbers

    def _get_dimension(self):
        """Get dimension of the vector"""
        return len(self._numbers)

    def __mul__(self,other):
        """Vector multiplication
        other - vector with same dimension
        """
        if len(self._numbers)!=len(other._numbers):
            raise ValueError('dimension mismatch')
        numbers = [a*b for a,b in zip(self._numbers,other._numbers)]
        return sum(numbers)

    def __add__(self,other):
        """Vector multiplication
        other - vector with same dimension
        """
        if len(self._numbers)!=len(other._numbers):
            raise ValueError('dimension mismatch')
        numbers = [a+b for a,b in zip(self._numbers,other._numbers)]
        return Vector(numbers)

    def __str__(self):
        return "{"+(",".join([str(x) for x in self._numbers]))+"}"

    def _get_length(self):
        return sum([x**2 for x in self._numbers])**0.5

    def _set_length(self,length):
        old_length = self._get_length()
        self._numbers = [x*length/old_length for x in self._numbers]

    def _del_length(self):
        self._set_length(0)

    length = property(_get_length,_set_length,_del_length)

class Vector3D(Vector):
    def __init__(self,x,y,z):
        """Initialize the vector.
        x,y,z - three dimensions
        """
        self._numbers  = [x,y,z]

    def __pow__(self,other):
        x,y,z = self._numbers[1]*other._numbers[2]-self._numbers[2]*other._numbers[1],self._numbers[2]*other._numbers[0]-self._numbers[0]*other._numbers[2],self._numbers[0]*other._numbers[1]-self._numbers[1]*other._numbers[0]
        
        return Vector3D(x,y,z)

if __name__ == '__main__':
    v1 = Vector([2,3,4,6])
    v2 = Vector([3,2,1,4])
    v3 = v1 + v2
    print(str(v3))
    print(v1.length)
    v1.length = 5
    print(v1.length)
    del v1.length
    print(v1.length)


