"""
School Advanced Programming in Python
OOP and Design Patterns

Solution to Decorator Pattern Exercise

by: Bartosz Telenczuk, Niko Wilbert
"""

class Beverage:

    def get_description(self):
        return "beverage"

    def get_cost(self):
        return 0.00

        
class DecoratedBeverage(Beverage):

    def __init__(self, beverage):
        super().__init__()  # not really needed here
        self.beverage = beverage
        
         
class Coffee(Beverage):

    def get_description(self):
        return "normal coffee"

    def get_cost(self):
        return 3.00
    

class Milk(DecoratedBeverage):

    def get_description(self):
        return self.beverage.get_description() + ", with milk"

    def get_cost(self):
        return self.beverage.get_cost() + 0.30


class Sugar(DecoratedBeverage):

    def get_description(self):
        return self.beverage.get_description() + ", with sugar"

    def get_cost(self):
        return self.beverage.get_cost() + 0.50
        

coffee_with_milk = Milk(Coffee())
print("Your {drink} costs {price:3.2f}.".format(drink=coffee_with_milk.get_description(),
                                           price=coffee_with_milk.get_cost()))
