#include <cmath>
#include <vector>
#include <stdexcept>

#include "Vector.h"


Vector::Vector(){
    x = 0.0;
    y = 0.0;
    z = 0.0;
};

Vector::Vector(double fx, double fy, double fz){
    x = fx;
    y = fy;
    z = fz;
};

double Vector::length(){
    return sqrt(x*x+y*y+z*z);
};

std::vector<double> Vector::coordinates(){
    double values[] = {x,y,z};
    std::vector<double> v (values,values+sizeof(values)/sizeof(double));
    return v;
};

Vector Vector::operator+(const Vector& rhs){
    return Vector(x+rhs.x,y+rhs.y,z+rhs.z);
};

Vector Vector::operator-(){
    return Vector(-x,-y,-z);
};

Vector Vector::operator*(double a){
    return Vector(a*x,a*y,a*z);
};

double Vector::operator*(const Vector& rhs){
    return x*rhs.x+y*rhs.y+z*rhs.z;
};

Vector Vector::operator^(const Vector& rhs){
    return Vector(y*rhs.z-z*rhs.y,
                  z*rhs.x-x*rhs.z,
                  x*rhs.y-y*rhs.x);
};
