import unittest
from prime import find_factors
from random import choice
from numpy import prod
from hypothesis import given
from hypothesis import strategies as st


class PrimeTester(unittest.TestCase):
    primes = [2,3,5,7,11,13,17,19]

    def test_70(self):
        #given
        input_ = 70
        expect = [2,5,7]
        #when
        result = find_factors(70)
        #then
        self.assertEqual(result, expect)

    def test_fuzzy(self):
        for _ in range(10):
            expect = [choice(self.primes) for _ in range(6)]
            expect.sort()
            input_ = prod(expect)
            with self.subTest(config = expect):
                result = find_factors(input_)
                self.assertEqual(result, expect)

    def test_primes(self):
        for prime in self.primes:
            with self.subTest(config = prime):
                result = find_factors(prime)
                self.assertEqual(result, [prime])

    @given(st.integers(min_value=1))
    def test_hypo(self, value):
        result = find_factors(value)
        expect = prod(result)
        self.assertEqual(value, expect)

if __name__ == "__main__":
    unittest.main(verbosity=2)
